#!/bin/bash
# RustDesk Configuration Script for macOS
# RCS Andover Help Desk

# Configuration
SERVER_DOMAIN="help.rcsandover.com"
SERVER_KEY="pcY5GAVL3TkU9yXdPyH2rZ59GCk8XqRHWvnKyvZnOec="

echo "=========================================="
echo "RCS Andover RustDesk Configuration"
echo "=========================================="
echo ""

# Check if RustDesk is installed
RUSTDESK_APP="/Applications/RustDesk.app"
RUSTDESK_CONFIG="$HOME/Library/Preferences/com.carriez.rustdesk/RustDesk2.toml"
RUSTDESK_CONFIG_DIR="$HOME/Library/Preferences/com.carriez.rustdesk"

if [ ! -d "$RUSTDESK_APP" ]; then
    echo "❌ RustDesk is not installed."
    echo ""
    echo "Please download and install RustDesk first:"
    echo "https://github.com/rustdesk/rustdesk/releases/latest"
    echo ""
    echo "Look for: rustdesk-X.X.X-x86_64.dmg (Intel)"
    echo "      or: rustdesk-X.X.X-aarch64.dmg (Apple Silicon)"
    echo ""
    read -p "Press Enter to open download page..." dummy
    open "https://github.com/rustdesk/rustdesk/releases/latest"
    exit 1
fi

echo "✅ RustDesk is installed"
echo ""

# Create config directory if it doesn't exist
mkdir -p "$RUSTDESK_CONFIG_DIR"

# Create configuration file
echo "📝 Creating configuration file..."
cat > "$RUSTDESK_CONFIG" << EOF
[options]
custom-rendezvous-server = "$SERVER_DOMAIN"
relay-server = "$SERVER_DOMAIN"
key = "$SERVER_KEY"
api-server = "https://$SERVER_DOMAIN"
EOF

echo "✅ Configuration file created"
echo ""

# Check if RustDesk is running
if pgrep -x "RustDesk" > /dev/null; then
    echo "⚠️  RustDesk is currently running"
    echo ""
    read -p "Would you like to restart RustDesk now? (y/n): " RESTART
    
    if [ "$RESTART" = "y" ] || [ "$RESTART" = "Y" ]; then
        echo "🔄 Restarting RustDesk..."
        killall RustDesk 2>/dev/null
        sleep 2
        open -a RustDesk
        echo "✅ RustDesk restarted"
    else
        echo "⚠️  Please restart RustDesk manually for changes to take effect"
    fi
else
    echo "🚀 Starting RustDesk..."
    open -a RustDesk
    echo "✅ RustDesk started"
fi

echo ""
echo "=========================================="
echo "Configuration Complete!"
echo "=========================================="
echo ""
echo "Server: $SERVER_DOMAIN"
echo "Config: $RUSTDESK_CONFIG"
echo ""
echo "Your RustDesk ID will appear in the main window."
echo "Share this ID with RCS Andover support when needed."
echo ""
